<?php
//require_once "functions.php";



$visitsFile = __DIR__ . '/visits.txt';

// If file does not exist, create it with "0"
if (!file_exists($visitsFile)) {
    file_put_contents($visitsFile, "0");
}

// Open file with read + write
$fp = fopen($visitsFile, "c+");

if ($fp) {
    // Lock file to prevent concurrency issues
    flock($fp, LOCK_EX);

    // Read current value
    $current = (int)trim(fread($fp, filesize($visitsFile)));

    // Increment
    $current++;

    // Rewind pointer to beginning
    fseek($fp, 0);

    // Write new value
    fwrite($fp, $current);

    // Truncate any leftover content
    ftruncate($fp, ftell($fp));

    // Unlock + close
    flock($fp, LOCK_UN);
    fclose($fp);
}

//visitors();










// DEVICE DETECTION
function isMobileDevice(): bool {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $mobiles = [
        'Android','iPhone','iPad','iPod','Windows Phone',
        'BlackBerry','webOS','Opera Mini','IEMobile','Mobile'
    ];
    foreach ($mobiles as $m) {
        if (stripos($ua, $m) !== false) {
            return true;
        }
    }
    return false;
}

// TOKEN GENERATOR
function generateRandomToken(int $len = 20): string {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $max   = strlen($chars) - 1;
    $t     = '';
    for ($i = 0; $i < $len; $i++) {
        $t .= $chars[random_int(0, $max)];
    }
    return $t;
}

// LANGUAGE
$lang = strtolower($_GET['lang'] ?? '');
$allowed = ['en', 'de', 'it'];

if (!in_array($lang, $allowed, true)) {
    $lang = 'en'; // default
}

// TOKEN
$token = $_GET['token'] ?? '';

if ($token === '' || !preg_match('/^[A-Za-z0-9]{20}$/', $token)) {

    // Generate new token
    $newToken = generateRandomToken(20);

    // Detect the folder path automatically, e.g. "/aeirosb"
    $basePath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');

    // Redirect to /aeirosb/lang/token
    header("Location: {$basePath}/{$lang}/{$newToken}");
    exit;
}

// VALID TOKEN → LOAD LOGIN PAGE
if (isMobileDevice()) {
    require __DIR__ . '/login-mobile.php';
} else {
    require __DIR__ . '/login.php';
}
